package com.qy.test.weiget.recyclerview;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.qy.test.base.GlideApp;
import com.qy.test.base.R;
import com.qy.test.reflect.FieldDisplayItem;
import com.qy.test.reflect.ShowType;
import com.qy.test.utils.ImageUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomListAdapter extends RecyclerView.Adapter<CustomListAdapter.ViewHolder> {

    private static final String TAG = CustomListAdapter.class.getSimpleName();
    private Context mContext;

    private List<FieldDisplayItem> data;

    private CustomBaseListView.OnItemClickListener mListener;

    public CustomListAdapter(Context context, List<FieldDisplayItem> list, CustomBaseListView.OnItemClickListener listener){
        this.mContext = context;
        this.data = list;
        this.mListener = listener;
    }

    @NonNull
    @Override
    public CustomListAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        View view = LayoutInflater.from(mContext).inflate(R.layout.base_item_list, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull CustomListAdapter.ViewHolder holder, int position) {
        FieldDisplayItem item = data.get(position);
        if (item.separateHeight<=0){
            holder.v_top_separate.setVisibility(View.GONE);
        }else{
            holder.v_top_separate.setVisibility(View.VISIBLE);
            holder.v_top_separate.getLayoutParams().height = item.separateHeight;
            holder.v_top_separate.setBackgroundColor(Color.parseColor(item.separateBgColor));
        }


        if (TextUtils.isEmpty(item.leftIcon)){
            holder.iv_left_icon.setVisibility(View.GONE);

        }else{
            holder.iv_left_icon.setVisibility(View.VISIBLE);
            holder.iv_left_icon.setImageResource(mContext.getResources().getIdentifier(item.leftIcon,"mipmap",mContext.getPackageName()));
        }
        holder.tv_label.setText(item.label);

        if(item.showType ==ShowType.TEXT){
            holder.tv_desc.setVisibility(View.VISIBLE);
            holder.tv_desc.setText(String.valueOf(item.value));
        }else{
            holder.tv_desc.setVisibility(View.GONE);
        }
        if (item.showType== ShowType.IMAGE){
            holder.iv_img.setVisibility(View.VISIBLE);
            GlideApp.with(mContext).load(item.value.toString()).into(holder.iv_img);
        }else{
            holder.iv_img.setVisibility(View.GONE);
        }
        if (item.isHasNext()){
            holder.iv_next.setVisibility(View.VISIBLE);
        }else{
            holder.iv_next.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        private View v_top_separate;
        private LinearLayout ll_item;
        private ImageView iv_left_icon, iv_img,iv_next;
        private TextView tv_label, tv_desc;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            v_top_separate = itemView.findViewById(R.id.v_top_separate);
            ll_item = itemView.findViewById(R.id.ll_item);
            iv_left_icon = itemView.findViewById(R.id.iv_left_icon);
            iv_img = itemView.findViewById(R.id.iv_img);
            iv_next = itemView.findViewById(R.id.iv_next);
            tv_label = itemView.findViewById(R.id.tv_label);
            tv_desc = itemView.findViewById(R.id.tv_desc);

            ll_item.setOnClickListener(v->{
                if (mListener != null){
                    mListener.onItemClick(getAbsoluteAdapterPosition());
                }
            });
            iv_img.setOnClickListener(v->{
                //点击预览图片，获取当前列表中的所有图片，然后在预览时显示当前点击的图片
                int clickPosition = getAbsoluteAdapterPosition();
                FieldDisplayItem curItem = data.get(clickPosition);
                List<String> list = new ArrayList<>();
                int curIndex=0;
                for (FieldDisplayItem item : data){
                    if (item.showType == ShowType.IMAGE){
                        if (curItem.getFieldName().equals(item.getFieldName())){
                            curIndex = list.size();
                        }
                        list.add(item.value.toString());
                    }
                }
                ImageUtils.openPreview(mContext, curIndex, list);
            });
        }
    }
}
