package com.qy.test.weiget.recyclerview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.qy.test.base.R;
import com.scwang.smart.refresh.layout.SmartRefreshLayout;

import java.util.List;

public class CustomBasePageListview extends ViewGroup {
    private SmartRefreshLayout refreshLayout;
    private RecyclerView mRecyclerView;

    private int pageSize =10;
    private int pageIndex = 1;

    public CustomBasePageListview(Context context) {
        super(context);

        init(context);
    }

    public CustomBasePageListview(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from(context).inflate(R.layout.base_layout_page_list, this, false);

        mRecyclerView = view.findViewById(R.id.rv_RecyclerView);
        mRecyclerView.setLayoutManager(new LinearLayoutManager(context));
        refreshLayout = view.findViewById(R.id.refreshLayout);

        addView(view);
    }

    /**
     * 设置参数
     * @param adapter
     * @param listener
     */
    public void setAdapter(RecyclerView.Adapter adapter, OnLoadDataListener listener){
        setAdapter(adapter, true, true, listener);
    }

    /**
     *
     * @param adapter
     * @param enableRefresh
     * @param enableLoadMore
     * @param listener
     */
    public void setAdapter(RecyclerView.Adapter adapter, boolean enableRefresh, boolean enableLoadMore, OnLoadDataListener listener) {

        if (mRecyclerView != null){
            mRecyclerView.setAdapter(adapter);
        }
        refreshLayout.setEnableRefresh(enableRefresh);
        if (enableRefresh){
            refreshLayout.setOnRefreshListener(refreshlayout -> {
                pageIndex = 1;
                if (listener != null) {
                    listener.loadData(pageIndex, pageSize, false);
                }
            });
        }
        refreshLayout.setEnableLoadMore(enableLoadMore);
        if (enableLoadMore){
            refreshLayout.setOnLoadMoreListener(refreshlayout -> {
                pageIndex++;
                if (listener != null){
                    listener.loadData(pageIndex, pageSize, true);
                }
            });
        }
        if (enableRefresh){
            refreshLayout.autoRefresh(100);
        }
    }

    /**
     * 数据加载完成后需要调用该方法
     * @param newData 接口返回的数据，注意这里不是显示的数据，而是本次接口请求返回的列表数据
     */
    public void loadSuccess(List<?> newData) {
        if (newData.size() <  pageSize){
            if (refreshLayout.isRefreshing()){
                refreshLayout.finishRefreshWithNoMoreData();
            }else if (refreshLayout.isLoading()){
                refreshLayout.finishLoadMoreWithNoMoreData();
            }
        }else {
            if (refreshLayout.isRefreshing()){
                refreshLayout.finishRefresh(100, true, true);
            }else if (refreshLayout.isLoading()){
                refreshLayout.finishLoadMore(100, true,true);
            }
        }

    }

    /**
     * 数据加载出现异常需要加载该方法来恢复原来的数据
     */
    public void loadError() {
        if (refreshLayout.isRefreshing()){
            refreshLayout.finishRefresh(100, false, true);
        }else if (refreshLayout.isLoading()){
            refreshLayout.finishLoadMore(100, false,true);
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (getChildCount() > 0) {
            View child = getChildAt(0);
            child.layout(0, 0, getMeasuredWidth(), getMeasuredHeight());
        }
    }
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (getChildCount() > 0) {
            View child = getChildAt(0);
            measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }


    public interface OnLoadDataListener {
        /**
         *
         * @param pageIndex 当前页
         * @param pageSize  分页大小
         * @param append   是否追加数据 true:加载更多，false:数据刷新
         */
        void loadData(int pageIndex, int pageSize, boolean append);
    }
}
