package com.qy.test.utils;

import android.content.Context;
import android.util.Log;

import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnExternalPreviewEventListener;

import java.util.ArrayList;
import java.util.List;

public class ImageUtils {

    public static void openPreview(Context context, int index,List<String> list){
        ArrayList<LocalMedia> mediaList = new ArrayList<>();
        for (String path : list) {
            LocalMedia media = new LocalMedia();
            media.setPath(path);
            media.setMimeType(PictureMimeType.MIME_TYPE_IMAGE);
            mediaList.add(media);
        }
        Log.d("图片预览", "openPreview: "+list);
        PictureSelector.create(context).openPreview().setImageEngine(GlideEngine.createGlideEngine())
                .setExternalPreviewEventListener(new OnExternalPreviewEventListener() {
                    @Override
                    public void onPreviewDelete(int position) {

                    }

                    @Override
                    public boolean onLongPressDownload(Context context, LocalMedia media) {
                        return false;
                    }
                }).startActivityPreview(index, false, mediaList);
    }
}
