package com.qy.test.reflect;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.*;

public class ReflectUtils {

    public static List<FieldDisplayItem> extractAnnotatedFields(Object bean) {
        List<FieldDisplayItem> list = new ArrayList<>();
        Class<?> clazz = bean.getClass();
        while (clazz != null && clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                FieldMeta annotation = field.getAnnotation(FieldMeta.class);
                if (annotation == null || annotation.name().isEmpty()) {
                    //这里验证如果没有使用该注解或者name为空的时，不需要加入到列表数据中
                    continue;
                }

                //打开private 和protected的访问权限
                field.setAccessible(true);
                try {
                    Object value = field.get(bean);
                    //判断当字段值为空的时候时需要将该字段显示出来
                    if (value== null && !annotation.nullShow()) {
                        continue;
                    }

                    FieldDisplayItem item = new FieldDisplayItem();
                    item.label = annotation.name();
                    item.fieldName = field.getName();
                    item.value = value;
                    item.unit = annotation.unit();
                    item.dataType = annotation.dataType();
                    item.showType =annotation.showType();
                    item.order = annotation.order();
                    item.hasNext = annotation.hasNext();
                    item.leftIcon = annotation.leftIcon();
                    item.separateHeight = annotation.separateHeight();
                    item.separateBgColor = annotation.separateBgColor();

                    if (annotation.dataType() == FieldType.DATE){
                        //如果数值是日期，则需要转换成日期类型
                        if (annotation.dateFormat()!=  null && !annotation.dateFormat().isEmpty()){
                            SimpleDateFormat format =new SimpleDateFormat(annotation.dateFormat());
                            if (annotation.dateType()==DateType.DATETIME){
                                Date date = new Date(item.value.toString());
                                item.value = format.format(date.getTime());
                            }else if (annotation.dateType()==DateType.TIMESTAMP){
                                item.value = format.format(item.value);
                            }else if (annotation.dateType()==DateType.DATE){
//                                Date date = new Date(item.value.toString());
//                                item.value = format.format(date.getTime());
                            }else if (annotation.dateType()==DateType.TIME){
//                                Date date = new Date(item.value.toString());
//                                item.value = format.format(date.getTime());
                            }
                        }
                    }

                    if (item.showType==ShowType.IMAGE){
                        String url = item.value.toString();
                        if (!url.startsWith("http")){

                        }
                    }


                    list.add(item);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            clazz = clazz.getSuperclass();  // 继续读取父类字段
        }
        list.sort(Comparator.comparingInt(FieldDisplayItem::getOrder));  // 按顺序排序
        return list;
    }
}
