package com.qy.test.reflect;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface  FieldMeta {

    /**
     * 字段名称
     * @return
     */
    String name();
    /**
     * 字段为空时是否显示
     * @return
     */
    boolean nullShow() default true;

    /**
     * 字段显示顺序
     * @return
     */
    int order() default Integer.MAX_VALUE;
    /**
     * 字段数据类型
     * @return
     */
    FieldType dataType() default  FieldType.STRING;

    /**
     * 日期类型
     * @return
     */
    DateType dateType() default DateType.DATETIME;
    /**
     * 显示类型
     * @return
     */
    ShowType showType() default ShowType.TEXT;

    /**
     * 日期解析显示格式
     * @return
     */
    String dateFormat() default "";

    /**
     * 单位
     * @return
     */
    String unit() default "";

    /**
     * 左侧图片
     * @return
     */
    String leftIcon() default "";

    /**
     * 分隔高度-显示在上面
     * @return
     */
    int separateHeight() default 2;

    /**
     * 分隔背景颜色
     * @return
     */
     String separateBgColor() default "#EFEFEF";

    /**
     * 是否有下一级
     * @return
     */
    boolean hasNext() default false;
}
