package com.qy.test.app1;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;

import com.qy.test.app1.databinding.ActivityStartBinding;
import com.qy.test.base.BaseActivity;

public class StartActivity extends BaseActivity {

    private ActivityStartBinding binding;

    private Handler uiHandler = new Handler(Looper.getMainLooper());

    @Override
    public View getContentLayout() {
        binding = ActivityStartBinding.inflate(getLayoutInflater());
        return binding.getRoot();
    }

    @Override
    public void initView() {
        Log.d(TAG, "onResume: 启动第二个应用");
        startActivity("2");
    }

    @Override
    protected void onResume() {
        super.onResume();
        String packageName = getPackageName();
        uiHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (isAppInForeground(StartActivity.this)){
                    startActivity(new Intent(StartActivity.this, MainActivity.class));
                }else {
                    Log.d(TAG, "run: 切换应用到前台， package=" + packageName);
                    appMoveToFront(packageName);
                }
            }
        }, 5*1000);

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        uiHandler.removeCallbacksAndMessages(null);
    }
}
