package com.qy.test.app;

import com.qy.test.reflect.FieldMeta;
import com.qy.test.reflect.FieldType;
import com.qy.test.reflect.ShowType;


import java.math.BigDecimal;

public class MeterialBean {

    private Integer id;


    @FieldMeta(name = "物料分类id", order = 1, dataType = FieldType.NUMBER,showType = ShowType.TEXT)
    private Integer classId;


    @FieldMeta(name = "物料分类名称", order = 3, separateHeight = 20, separateBgColor = "#BB86FC")
    private String className;


    private Integer altergroupId;

    @FieldMeta(name = "物料编码", order = 2, leftIcon = "add_field_default",hasNext = true)
    private String meterialCode;


    @FieldMeta(name = "物料名称")
    private String meterialName;

    @FieldMeta(name = "品牌")
    private String manufacturer;

    @FieldMeta(name = "型号")
    private String specId;

    /**
         * 特征属性，关键属性+重要属性
     */
    @FieldMeta(name = "特征属性", order = 4, showType = ShowType.IMAGE)
    private String property;

    /**
         * 最小包装1
     */
    private Short minPackage1;

    /**
         * 最小包装2
     */
    private Short minPackage2;

    /**
         * 状态 0=禁用 1=可用
     */
    private Integer status;

    /**
         * 参考价格
     */
    private BigDecimal price;

    /**
         * 价值分类
     */
    private String valueLevel;

    /**
         * 备注
     */
    private String remark;

    /**
         * zuken库的partName
     */
    private String partName;

    /**
         * zuken库的Value，关键属性1
     */
    private String partValue;

    /**
         * 嘉立创物料编码
     */
    private String jlcCode;

    /**
         * 是否贴片物料
     */
    private Boolean smd;

    /**
         * 封装, 关键属性2
     */
    private Integer footprintId;

    /**
         * 扩展属性
     */
    private String propExt;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getClassId() {
        return classId;
    }

    public void setClassId(Integer classId) {
        this.classId = classId;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Integer getAltergroupId() {
        return altergroupId;
    }

    public void setAltergroupId(Integer altergroupId) {
        this.altergroupId = altergroupId;
    }

    public String getMeterialCode() {
        return meterialCode;
    }

    public void setMeterialCode(String meterialCode) {
        this.meterialCode = meterialCode;
    }

    public String getMeterialName() {
        return meterialName;
    }

    public void setMeterialName(String meterialName) {
        this.meterialName = meterialName;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getSpecId() {
        return specId;
    }

    public void setSpecId(String specId) {
        this.specId = specId;
    }

    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Short getMinPackage1() {
        return minPackage1;
    }

    public void setMinPackage1(Short minPackage1) {
        this.minPackage1 = minPackage1;
    }

    public Short getMinPackage2() {
        return minPackage2;
    }

    public void setMinPackage2(Short minPackage2) {
        this.minPackage2 = minPackage2;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getValueLevel() {
        return valueLevel;
    }

    public void setValueLevel(String valueLevel) {
        this.valueLevel = valueLevel;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public String getPartValue() {
        return partValue;
    }

    public void setPartValue(String partValue) {
        this.partValue = partValue;
    }

    public String getJlcCode() {
        return jlcCode;
    }

    public void setJlcCode(String jlcCode) {
        this.jlcCode = jlcCode;
    }

    public Boolean getSmd() {
        return smd;
    }

    public void setSmd(Boolean smd) {
        this.smd = smd;
    }

    public Integer getFootprintId() {
        return footprintId;
    }

    public void setFootprintId(Integer footprintId) {
        this.footprintId = footprintId;
    }

    public String getPropExt() {
        return propExt;
    }

    public void setPropExt(String propExt) {
        this.propExt = propExt;
    }
}