package com.qy.test.app;

import android.os.Handler;
import android.os.Looper;
import android.view.View;

import com.qy.test.base.BaseActivity;
import com.qy.test.app.databinding.ActivityMainBinding;
import com.qy.test.reflect.ReflectUtils;
import com.qy.test.weiget.recyclerview.CustomListAdapter;

import java.util.Arrays;
import java.util.Random;

public class MainActivity extends BaseActivity {

    private ActivityMainBinding binding;
    private Handler uiHandler = new Handler(Looper.getMainLooper());

    @Override
    public View getContentLayout() {
        binding = ActivityMainBinding.inflate(getLayoutInflater());
        return binding.getRoot();
    }

    @Override
    public void initView() {

        MeterialBean bean = new MeterialBean();
        bean.setClassId(1);
        bean.setClassName("分类");
        bean.setMeterialCode("编码");
        bean.setMeterialName("名称");
        bean.setManufacturer("品牌");
        bean.setSpecId("规格");
        bean.setProperty("http://me-oss.oss-cn-qingdao.aliyuncs.com/web/bg.jpg");
        bean.setMinPackage1((short) 1);


        CustomListAdapter adapter = new CustomListAdapter(this, ReflectUtils.extractAnnotatedFields(bean), position -> {

        });

        binding.pageList.setAdapter(adapter, (pageIndex, pageSize, append) -> {
            uiHandler.postDelayed(() -> {
                Random random = new Random();
                int num = random.nextInt(10);
                if (num % 2 == 0) {
                    binding.pageList.loadSuccess(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
                } else {
                    binding.pageList.loadError();
                }
            }, 100);
        });

    }


}
