package com.qy.test.app;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;

public class GradientCircularProgressBar extends View {
    private Paint paint;
    private float progress = 0;
    private int[] colors = {0xFFFF0000, 0xFF00FF00, 0xFF0000FF}; // 渐变颜色

    public GradientCircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    private void init() {
        paint = new Paint();
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(20);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        // 计算渐变
        int width = getWidth();
        int height = getHeight();
        int radius = Math.min(width, height) / 2 - 20;

        RadialGradient gradient = new RadialGradient(width / 2, height / 2, radius,
                colors, null, Shader.TileMode.CLAMP);
        paint.setShader(gradient);

        // 画进度条
        canvas.drawCircle(width / 2, height / 2, radius, paint);

        // 画当前进度
        paint.setShader(null);
        paint.setColor(0xFF000000); // 黑色
        canvas.drawArc(20, 20, width - 20, height - 20, -90, progress * 360, false, paint);
    }

    public void setProgress(float progress) {
        this.progress = progress;
        invalidate(); // 重绘
    }
}
