package com.qy.test.app;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

import androidx.annotation.Nullable;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class CircleProgressBar extends View {

    private String TAG = "CircleProgressBar";

    private int mViewSize = 300;
    private int left=10,top=10;
    private List<SectorData> list;
    private int splitAngle =170; //角度分割

    public CircleProgressBar(Context context) {
        super(context);
        init(context);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(context);
    }

    private void init(Context context){
        list = new ArrayList<>();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        canvas.rotate(270, getWidth()/2f, getHeight()/2f);

        RectF rectF = new RectF(left,top,mViewSize+left,mViewSize+top);

        for (SectorData data: list) {
//            if (data.startAngle + data.angle>360){
//                canvas.drawArc(rectF, data.startAngle, data.angle, false, data.paint);
                //在这里需要将起始角度回退10度,然后绘制角度加大10度,这样就不会出现从360-0的的颜色错位问题,如果是单色的就不需要考虑该问题
                //canvas.drawArc(rectF, -10,
                  //      data.startAngle +data.angle - 360 +10, false, data.paint2);
//            }else {
                canvas.drawArc(rectF, data.startAngle, data.angle, false, data.paint);
            Log.d(TAG, "onDraw: " +data.startAngle +"============"+ data.angle);
//            }
        }

        //绘制里面的同心圆
        Paint paint = new Paint();
        //初始化弧形的画笔
        paint.setColor(Color.parseColor("#914acc"));
        paint.setFlags(Paint.ANTI_ALIAS_FLAG);
        paint.setStrokeWidth(1f);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(mViewSize/2+ left, mViewSize/2 + top, mViewSize/2-20, paint);

        // 虚线长度和间隔长度
        paint.setPathEffect(new DashPathEffect(new float[]{5, 5}, 0));
        canvas.drawCircle(mViewSize/2+ left, mViewSize/2 + top, mViewSize/2-50, paint);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        // 获取测量宽度和高度
        int width = MeasureSpec.getSize(widthMeasureSpec);
        int height = MeasureSpec.getSize(heightMeasureSpec);
        // 你可以在这里设置你的自定义宽高
        // 例如，保持宽高比
        int size = Math.min(width, height);
        mViewSize = size -20;
        setMeasuredDimension(size, size); // 设置为正方形
        postInvalidate();
    }

    /**
     *
     * @param normalAlarmCount 一般告警个数
     * @param importantAlarmCount 重要告警个数
     * @param criticalAlarmCount  紧急告警个数
     */
    public void updateData(int normalAlarmCount, int importantAlarmCount, int criticalAlarmCount){
        list.clear();
        float total = normalAlarmCount + importantAlarmCount + criticalAlarmCount;

        int normalAngle = (int)(normalAlarmCount/total *360);
        list.add(new SectorData(Color.GRAY, Color.GREEN, 00, normalAngle));
        
        int importantAngle = (int)(importantAlarmCount/total *360);
//        list.add(new SectorData(Color.GREEN, Color.YELLOW, normalAngle, importantAngle));
        
        int criticalAngle = (int)(criticalAlarmCount/total *360);
//        list.add(new SectorData(Color.YELLOW, Color.RED, normalAngle +importantAngle, criticalAngle));

        Log.d(TAG, "updateData: "+ list.toString());

        postInvalidate();
    }
    private class SectorData{
        //开始颜色
        private final int startColor;
        //结束颜色
        private final int endColor;
        //开始角度
        private final int startAngle;
        //旋转角度
        private final int angle;
        //画笔
        private Paint paint;
        private Paint paint2;

        public SectorData(int startColor, int endColor, int startAngle, int angle) {
            this.startColor = startColor;
            this.endColor = endColor;
            this.startAngle = startAngle;
            this.angle = angle;
            setPaint();
        }
        public void setPaint(){
            this.paint = new Paint();
            //初始化弧形的画笔
            this.paint.setFlags(Paint.ANTI_ALIAS_FLAG);
            this.paint.setStrokeWidth(20f);
//        paintArcTop.setStrokeCap(Paint.Cap.ROUND);
            this.paint.setStyle(Paint.Style.STROKE);
            int [] colorS={Color.BLACK, endColor, endColor};
            float[] pisitions = {0.0f, 0.33f, 1f};
            Shader sweepGradient = new SweepGradient(mViewSize/2, mViewSize/2, colorS, pisitions);
            this.paint.setShader(sweepGradient);


            this.paint2 = new Paint();
            //初始化弧形的画笔
            this.paint2.setColor(endColor);
            this.paint2.setFlags(Paint.ANTI_ALIAS_FLAG);
            this.paint2.setStrokeWidth(20f);
            this.paint2.setStyle(Paint.Style.STROKE);

        }
        @Override
        public String toString() {
            return "SectorData{" +
                    "startColor=" + startColor +
                    ", endColor=" + endColor +
                    ", startAngle=" + startAngle +
                    ", angle=" + angle +
                    ", paint=" + paint +
                    ", paint2=" + paint2 +
                    '}';
        }
    }

}
